<?php

namespace Modules\Recruit\Notifications;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;
use Modules\Recruit\Entities\RecruitEmailNotificationSetting;
use Modules\Recruit\Entities\RecruitInterviewSchedule;

class RecruiterUpdateInterviewSchedule extends BaseNotification
{

    private $interview;
    private $emailSetting;

    /**
     * Create a new notification instance.
     *
     * @return void
     */

    public function __construct(RecruitInterviewSchedule $interview)
    {
        $this->interview = $interview;
        $this->company = $this->interview->jobApplication->job->company;
        $this->emailSetting = RecruitEmailNotificationSetting::where('company_id', $this->company->id)->where('slug', 'notification-to-recruiter')->first();
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $via = ['database'];

        if ($this->emailSetting->send_email == 'yes' && $notifiable->email_notifications && $notifiable->email != null) {
            array_push($via, 'mail');
        }

        return $via;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $emailContent = (new MailMessage)
            ->subject(__('recruit::modules.adminMail.updateInterviewSubject'))
            ->greeting(__('email.hello') . ' ' . $notifiable->name . '!')
            ->line(__($this->interview->jobApplication->full_name) . ' ' . __('recruit::modules.adminMail.updateInterviewText') . ' - ' . $this->interview->jobApplication->job->title);

        if ($this->interview->interview_type == 'in person') {
            $emailContent = $emailContent->line(__('recruit::modules.interviewSchedule.interviewType') . ' - ' . __('recruit::app.interviewSchedule.inPerson'));

        }
        elseif ($this->interview->interview_type == 'video') {

            if ($this->interview->video_type == 'zoom') {
                $emailContent = $emailContent->line(__('recruit::modules.interviewSchedule.interviewType') . ' - ' . __('recruit::app.interviewSchedule.zoom'));

            }
            else {
                $emailContent = $emailContent->line(__('recruit::modules.interviewSchedule.interviewType') . ' - ' . $this->interview->other_link);
            }

        }
        elseif ($this->interview->interview_type == 'phone') {
            $emailContent = $emailContent->line(__('recruit::modules.interviewSchedule.interviewType') . ' - ' . $this->interview->phone);
        }

        $emailContent = $emailContent->line(__('recruit::modules.email.thankyouNote'));

        return $emailContent;
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray()
    {
        return [
            'user_id' => $this->interview->jobApplication->job->recruiter_id,
            'interview_id' => $this->interview->id,
            'heading' => $this->interview->jobApplication->full_name
        ];
    }

}
