<?php

namespace Modules\Recruit\Notifications;

use App\Notifications\BaseNotification;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Modules\Recruit\Entities\RecruitEmailNotificationSetting;
use Modules\Recruit\Entities\RecruitInterviewSchedule;

class AdminNewInterviewSchedule extends BaseNotification
{

    private $interview;
    private $emailSetting;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(RecruitInterviewSchedule $interview)
    {
        $this->interview = $interview;
        $this->company = $this->interview->jobApplication->job->company;
        $this->emailSetting = RecruitEmailNotificationSetting::where('company_id', $this->company->id)
            ->where('slug', 'new-interview-scheduleadded-by-admin')
            ->first();
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $via = ['database'];

        if ($this->emailSetting->send_email == 'yes' && $notifiable->email_notifications && $notifiable->email != null) {
            array_push($via, 'mail');
        }

        return $via;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $emailContent = parent::build()
            ->subject(__('recruit::modules.email.subject'))
            ->greeting(__('email.hello') . ' ' . $notifiable->name . '!')
            ->line(__($this->interview->jobApplication->full_name) . ' ' . __('recruit::modules.email.text') . ' - ' . ucwords($this->interview->jobApplication->job->title));

        if ($this->interview->interview_type == 'in person') {
            $emailContent = $emailContent->line(__('recruit::modules.interviewSchedule.interviewType') . ' - ' . __('recruit::app.interviewSchedule.inPerson'));
        }
        elseif ($this->interview->interview_type == 'video') {
            if ($this->interview->video_type == 'zoom') {
                $emailContent = $emailContent->line(__('recruit::modules.interviewSchedule.interviewType') . ' - ' . __('recruit::app.interviewSchedule.zoom'));
            }
            else {
                $emailContent = $emailContent->line(__('recruit::modules.interviewSchedule.interviewType') . ' - ' . ucwords($this->interview->other_link));
            }
        }
        elseif ($this->interview->interview_type == 'phone') {
            $emailContent = $emailContent->line(__('recruit::modules.interviewSchedule.interviewType') . ' - ' . ucwords($this->interview->phone));
        }

        return $emailContent->line(__('recruit::modules.email.thankyouNote'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        $this->recruiter = RecruitInterviewSchedule::with('user')->where('id', $this->interview->id)->first();

        return [
            'user_id' => $notifiable->id,
            'interview_id' => $this->interview->id,
            'heading' => $this->interview->jobApplication->full_name,
        ];
    }

}
