<?php

namespace Modules\Recruit\Notifications;

use App\Notifications\BaseNotification;
use Illuminate\Notifications\Messages\MailMessage;
use Modules\Recruit\Entities\RecruitEmailNotificationSetting;
use Modules\Recruit\Entities\RecruitJobOfferLetter;

class UpdateOfferLetter extends BaseNotification
{

    private $offer;
    private $emailSetting;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(RecruitJobOfferLetter $offer)
    {
        $this->offer = $offer;
        $this->company = $this->offer->job->company;
        $this->emailSetting = RecruitEmailNotificationSetting::where('company_id', $this->company->id)->where('slug', 'notification-to-recruiter')->first();
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $via = ['database'];

        if ($this->emailSetting->send_email == 'yes' && $notifiable->email_notifications && $notifiable->email != null) {
            array_push($via, 'mail');
        }

        return $via;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $url = route('jobs.index');
        $url = getDomainSpecificUrl($url, $this->company);

        return parent::build()
            ->subject(__('recruit::modules.updateOffer.subject'))
            ->greeting(__('email.hello') . ' ' . $notifiable->name . '!')
            ->line(__($this->offer->jobApplication->full_name) . ' (' . ($this->offer->jobApplication->email ?: '') . ') - ' . __('recruit::modules.updateOffer.text') . ' ' . $this->offer->job->title)
            ->action(__('recruit::modules.email.loginDashboard'), $url);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'user_id' => $notifiable->id,
            'offer_id' => $this->offer->id,
            'heading' => $this->offer->jobApplication->full_name
        ];
    }

}
