<?php

namespace Modules\Recruit\Http\Controllers\Front;

use App\Models\Company;
use Illuminate\Support\Facades\App;
use App\Http\Controllers\Controller;

class FrontBaseController extends Controller
{

    /**
     * @var array
     */
    public $data = [];

    /**
     * @param $name
     * @param $value
     */
    public function __set($name, $value)
    {
        $this->data[$name] = $value;
    }

    /**
     * @param $name
     * @return mixed
     */
    public function __get($name)
    {
        return $this->data[$name];
    }

    /**
     * @param $name
     * @return bool
     */
    public function __isset($name)
    {
        return isset($this->data[$name]);
    }

    /**
     * UserBaseController constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->global = global_setting();


        if (isWorksuite()) {
            $this->company = Company::first();
        }

        App::setLocale($this->company->locale);
        setlocale(LC_TIME, $this->company->locale . '_' . strtoupper($this->company->locale));
    }

}
