<?php

namespace Modules\Recruit\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Modules\Recruit\Entities\RecruitJobApplication;

class NewJobApplicationEvent
{

    use Dispatchable, InteractsWithSockets, SerializesModels;


    public $jobApplication;

    /**
     * Create a new event instance.
     *
     * @return void
     */

    public function __construct(RecruitJobApplication $jobApplication)
    {
        $this->jobApplication = $jobApplication;
    }

    /**
     * Get the channels the event should be broadcast on.
     *
     * @return array
     */
    public function broadcastOn()
    {
        return [];
    }

}
